package net.bluemind.marketplace.api;

import java.io.IOException;

import net.bluemind.marketplace.tools.StaticTools;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;

public class Getters {
	private static HttpClient httpClient = StaticTools.getHttpClient(true);
	private static String API_KEY = "your_api_key";
	private static String WEBSITE = "https://marketplace.blue-mind.net/";

	private static void getPlugins() throws IOException {
		HttpGet httpGet = new HttpGet(WEBSITE + "/addons/api/plugins/");
		httpGet.addHeader("api-key", API_KEY);
		ResponseHandler<String> handler = new BasicResponseHandler();
		HttpResponse rep = httpClient.execute(httpGet);
		if (rep != null) {
			int statusCode = rep.getStatusLine().getStatusCode();
			System.out.println("Status code : " + statusCode);
			if (statusCode == 200) {
				System.out.println("Contents : " + handler.handleResponse(rep));
			}
		}
	}
	
	private static void getPlugin(int id) throws IOException {
		HttpGet httpGet = new HttpGet(WEBSITE + "/addons/api/plugin/" + id);
		httpGet.addHeader("api-key", API_KEY);
		ResponseHandler<String> handler = new BasicResponseHandler();
		HttpResponse rep = httpClient.execute(httpGet);
		if (rep != null) {
			int statusCode = rep.getStatusLine().getStatusCode();
			System.out.println("Status code : " + statusCode);
			if (statusCode == 200) {
				System.out.println("Contents : " + handler.handleResponse(rep));
			}
		}
	}

	public static void main(String[] args) {
		if (httpClient == null)
			return;
		
		try {
			getPlugins();
			System.out.println();
			getPlugin(6);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
