package net.bluemind.marketplace.api;

import java.io.File;
import java.io.IOException;

import net.bluemind.marketplace.tools.StaticTools;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.json.simple.JSONObject;

public class Posters {
	private static HttpClient httpClient = StaticTools.getHttpClient(true);
	private static String API_KEY = "your_api_key";
	private static String WEBSITE = "https://marketplace.blue-mind.net/";
	
	@SuppressWarnings("unchecked")
	private static void postPlugin() throws IOException {
		HttpPost httpPost = new HttpPost(WEBSITE + "/addons/api/plugins/");
		MultipartEntityBuilder builder = MultipartEntityBuilder.create();
		ContentType contentType = ContentType.getOrDefault(null);
		
		// Json part
		JSONObject j = new JSONObject();
		j.put("api_key", API_KEY);
		j.put("name", "Super plugin");
		j.put("shortdesc", "A short description");
		j.put("description", "A long description");
		j.put("license", "A license");
		j.put("installation_instructions", "Several instructions");
		j.put("home_url", "https://google.fr");
		StringBody json = new StringBody(j.toString(), contentType);
		
		// Files part
		FileBody thumbnail = new FileBody(new File("/home/user/Images/thumbnail.jpg"));
		FileBody screen1 = new FileBody(new File("/home/user/Images/screenshot1.png"));
		FileBody screen2 = new FileBody(new File("/home/user/Images/screenshot2.png"));
		
		// Grouping
		builder.addPart("json", json);
		builder.addPart("thumbnail", thumbnail);
		builder.addPart("screen1", screen1);
		builder.addPart("screen2", screen2);
		
		httpPost.setEntity(builder.build());
		HttpResponse rep = httpClient.execute(httpPost);
		if (rep != null) {
			int statusCode = rep.getStatusLine().getStatusCode();
			System.out.println("Status code : " + statusCode);
		}
	}
	
	@SuppressWarnings("unchecked")
	private static void postPluginVersion() throws IOException {
		HttpPost httpPost = new HttpPost(WEBSITE + "/addons/api/plugin_version/");
		MultipartEntityBuilder builder = MultipartEntityBuilder.create();
		ContentType contentType = ContentType.getOrDefault(null);
		
		// Json part
		JSONObject j = new JSONObject();
		j.put("api_key", API_KEY);
		j.put("plugin_name", "Super plugin");
		j.put("version", "0.2");
		j.put("target_bm_versions", "3.x");
		j.put("release_notes", "On vient de faire une nouvelle release");
		StringBody json = new StringBody(j.toString(), contentType);
		
		// Files part
		FileBody pack = new FileBody(new File("/home/user/Files/super_plugin.jar"));
		
		// Grouping
		builder.addPart("json", json);
		builder.addPart("package", pack);
		
		httpPost.setEntity(builder.build());
		HttpResponse rep = httpClient.execute(httpPost);
		if (rep != null) {
			int statusCode = rep.getStatusLine().getStatusCode();
			System.out.println("Status code : " + statusCode);
		}
	}
	
	public static void main(String[] args) {
		try {
			postPlugin();
			postPluginVersion();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
