package net.bluemind.marketplace.tools;

import java.io.IOException;
import java.security.cert.X509Certificate;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class StaticTools {
	public static HttpClient getHttpClient(boolean useSSL) {
		if (!useSSL) {
			return HttpClientBuilder.create().build();
		}
		
		try {
			SSLContextBuilder builder = SSLContexts.custom();
			builder.loadTrustMaterial(null, new TrustStrategy() {
			    @Override
			    public boolean isTrusted(X509Certificate[] chain, String authType) {
			        return true;
			    }
			});
			SSLContext sslContext = builder.build();
			SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(
			        sslContext, new X509HostnameVerifier() {
			            @Override
			            public void verify(String host, SSLSocket ssl)
			                    throws IOException {
			            }

			            @Override
			            public void verify(String host, X509Certificate cert)
			                    throws SSLException {
			            }

			            @Override
			            public void verify(String host, String[] cns,
			                    String[] subjectAlts) throws SSLException {
			            }

			            @Override
			            public boolean verify(String s, SSLSession sslSession) {
			                return true;
			            }
			        });

			Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder
			        .<ConnectionSocketFactory> create().register("https", sslsf)
			        .build();

			PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(
			        socketFactoryRegistry);
			return HttpClients.custom()
			        .setConnectionManager(cm).build();
		} catch (Throwable t) {
			t.printStackTrace();
			return null;
		}
	}
}
